# Minimal loader for ExabyteTV (cross-version)
import os, sys, base64, types

_KEY = b"ExaKey23"

def _dec_path(rel):
    p = os.path.join(os.path.dirname(__file__), rel)
    with open(p, "r", encoding="utf-8") as fh:
        data = base64.b64decode(fh.read())
    data = bytes([data[i] ^ _KEY[i % len(_KEY)] for i in range(len(data))])
    return data.decode("utf-8")

# Preload package path resources.lib to allow "from resources.lib import api"
pkg_name = "resources"
if pkg_name not in sys.modules:
    sys.modules[pkg_name] = types.ModuleType(pkg_name)
    sys.modules[pkg_name].__path__ = []

subpkg = "resources.lib"
if subpkg not in sys.modules:
    sys.modules[subpkg] = types.ModuleType(subpkg)
    sys.modules[subpkg].__path__ = []

# Load and register resources.lib.api BEFORE running main
api_src = _dec_path(os.path.join("resources", "lib", "api.dat"))
mod_api = types.ModuleType("resources.lib.api")
exec(compile(api_src, "resources/lib/api.py", "exec"), mod_api.__dict__)
sys.modules["resources.lib.api"] = mod_api

# Now run the original default.py
main_src = _dec_path("default.dat")
exec(compile(main_src, "default.py", "exec"), globals(), globals())
